local TableUtil, FUTLoginManager, VirtualButton, eventmanager, CABModel, FeatureTileModel, Timer, Login_Service = ...
local LoginStatus = FUTLoginManager.FeCards.LoginStatus
local EventTypes = eventmanager.FE.FIFA.EventTypes
local LoginFrom = Login_Service.FE.UXService.BaseService.LoginFrom
local MainHub = {}
local bndFUTTitle = "bnd_live_tile_fut"
local bndAccomplishmentsTitle = "bnd_live_tile_accomplishments"
local bndHelpTitle = "bnd_live_tile_help"
local bndAboutTitle = "bnd_live_tile_about"
local bndAdvertTitle = "bnd_live_tile_advert"
local bndEnableFUT = "bnd_enable_fut"
local bndLiveTileList = "bnd_live_tile_list"
local BND_DEBUG_VISIBILITY = "BND_DEBUG_VISIBILITY"
local LOGIN_RETRY_TIMER = 300

local LiveTileTest = {}
local bndLiveQuickMatchTileList = "bnd_live_quick_match_tile_list"

function MainHub:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  print("MainHub:new()")
  o.services = {
    liveTilesService = o.api("LiveTilesService"),
    userinfo = o.api("FUTUserInfoService"),
    futsquadmgmt = o.api("FUTSquadManagementService"),
    EventManagerService = o.api("EventManagerService"),
    LoginService = o.api("LoginService"),
    SpeechDownloadService = o.api("SpeechDownloadService")
  }
  o.powService = o.api("PowService")
  o.screenName = "worldmainhub"
  o.models = {
    CABModel = CABModel:new({
      im = o.im,
      api = o.api,
      loc = o.loc,
      nav = o.nav,
      screenName = o.screenName
    }),
    FeatureTileModel = FeatureTileModel:new({
      im = o.im,
      api = o.api,
      loc = o.loc,
      nav = o.nav,
      viewType = "normal",
      imageScale = 1
    })
  }
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end
  )
  o.futTileData = {}
  o.accomplishmentsTileData = {}
  o.isFUTReady = false
  o.showLoginFailure = true
  local loginStatus = o.services.userinfo.GetLoginStatus()
  if loginStatus == LoginStatus.LS_CONNECTED then
    o.services.futsquadmgmt.LoadActiveSquad()
    o.isFUTReady = true
  end
  o.futTileData = o.services.liveTilesService.GetViewData_MAINHUB_FUT()
  o.accomplishmentsTileData = o.services.liveTilesService.GetViewData_MAINHUB_ACCOMPLISHMENTS()
  o.helpTileData = o.services.liveTilesService.GetViewData_MAINHUB_HELP()
  o.aboutTileData = o.services.liveTilesService.GetViewData_MAINHUB_ABOUT()
  o.services.liveTilesService.OnMainMenuEnter()
  o.advertTileData = {}
  o.debugVisibility = true
  if EA_FINAL == true and RL_BUILD == true then
    o.debugVisibility = false
  end
  o.im.Subscribe(BND_DEBUG_VISIBILITY, function()
    o.im.Publish(BND_DEBUG_VISIBILITY, o.debugVisibility)
  end
  )
  o.im.Subscribe(bndFUTTitle, function()
    o.im.Publish(bndFUTTitle, o.futTileData)
  end
  )
  o.im.Subscribe(bndAccomplishmentsTitle, function()
    o.im.Publish(bndAccomplishmentsTitle, o.accomplishmentsTileData)
  end
  )
  o.im.Subscribe(bndHelpTitle, function()
    o.im.Publish(bndHelpTitle, o.helpTileData)
  end
  )
  o.im.Subscribe(bndAboutTitle, function()
    o.im.Publish(bndAboutTitle, o.aboutTileData)
  end
  )
  o.im.Subscribe(bndAdvertTitle, function()
    o:publishBannerData()
  end
  )
  o.im.Subscribe(bndEnableFUT, function()
    o.im.Publish(bndEnableFUT, o.isFUTReady)
  end
  )
  o.helpAboutTile = {}
  o.helpTileData.clickAction = "act_to_help_hub"
  o.aboutTileData.clickAction = "act_to_about_hub"
  o.helpTileData.autoScaleImageToTileHeight = true
  o.aboutTileData.autoScaleImageToTileHeight = true
  table.insert(o.helpAboutTile, o.helpTileData)
  table.insert(o.helpAboutTile, o.aboutTileData)
  o.im.Subscribe(bndLiveTileList, function()
    o:_publishLiveTiles()
  end
  )
  o.powService.RequestAdBannersByScreen(o.screenName)

  o.liveTileLists = {}
  table.insert(o.liveTileLists, {
    headline = {
      "Quick Match"
    },
    description = "Play an offline quick match!",
    images = {
      "$SimulationPauseResumeTile"
    },
    status = "none",
    enablePop = "false",
    clickAction = "act_quick_match_mode"
  })
  o.im.Subscribe(bndLiveQuickMatchTileList, function()
    o:_publishLiveTiles()
  end
  )

  return o
end

function MainHub:_publishLiveTiles()
  local dataToPublish = {
    index = 0,
    data = self.helpAboutTile
  }
  self.im.Publish(bndLiveTileList, dataToPublish)
  local dataToPublish = {
    index = 0,
    data = self.liveTileLists
  }
  self.im.Publish(bndLiveQuickMatchTileList, dataToPublish)
end

function MainHub:handleEvent(eventType, data)
  if eventType == EventTypes.OnLoggedIn then
    self:onLoggedIn()
  elseif eventType == EventTypes.AdBannersDataAvailable then
    if data.screenName == self.screenName then
      local rawData = self.powService.GetAdBannersByScreen(self.screenName)
      local nData = table.getn(rawData)
      if nData > 0 then
        self.advertTileData = rawData
        self:publishBannerData()
      end
    end
  elseif eventType == EventTypes.AdBannersDataNotAvailable then
    if data.screenName == self.screenName then
      self.advertTileData = self.models.CABModel:getFakeData()
      self:publishBannerData()
    end
  elseif eventType == EventTypes.DeepLinkRedirect then
    print("MainHub:DeepLinkRedirect:", data.actionLink)
    if data.actionLink == "act_cab_buy_fifa_points" then
      self.nav.Event(nil, "evt_to_store", {redirect = "fifapoints"})
    elseif data.actionLink == "act_cab_to_store_my_packs" then
      self.nav.Event(nil, "evt_to_store", {redirect = "unassigned"})
    elseif data.actionLink == "act_cab_to_store_shop" then
      self.nav.Event(nil, "evt_to_store", {
        redirect = "consumablepacks"
      })
    elseif data.actionLink == "act_cab_to_store_player" then
      self.nav.Event(nil, "evt_to_store", {
        redirect = "regularpacks"
      })
    elseif data.actionLink == "act_cab_to_store" then
      self.nav.Event(nil, "evt_to_store", {redirect = "shop"})
    elseif data.actionLink == "act_cab_to_accomplishments" then
      self.nav.Event(nil, "evt_to_user_bio", {isInGame = false})
    elseif data.actionLink == "act_cab_to_fut_online_tournaments" then
      self.nav.Event(nil, "evt_shortcut_to_fut_online_tournaments")
    elseif data.actionLink == "act_cab_to_fut_offline_tournaments" then
      self.nav.Event(nil, "evt_shortcut_to_fut_offline_tournaments")
    elseif data.actionLink == "act_cab_to_fut_online_seasons" then
      self.nav.Event(nil, "evt_shortcut_to_fut_online_seasons")
    elseif data.actionLink == "act_cab_to_fut_offline_seasons" then
      self.nav.Event(nil, "evt_shortcut_to_fut_offline_seasons")
    elseif data.actionLink == "act_cab_to_fut_auction_house" then
      self.nav.Event(nil, "evt_shortcut_to_fut_auction_house")
    end
  end
end

function MainHub:publishBannerData()
  if self.advertTileData ~= nil then
    local dataToPublishAdvert = {
      index = 0,
      data = self.advertTileData
    }
    self.im.Publish(bndAdvertTitle, dataToPublishAdvert)
  end
end

function MainHub:showNoFutPopup()
  if self.showLoginFailure then
    local buttonOk = VirtualButton:new({
      nav = self.nav,
      label = "LTXT_CMN_OK",
      clickEvents = {
        "evt_hide_popup"
      }
    })
    local popupData = {
      title = "LTXT_CMN_SERVER_ERROR",
      message = "LTXT_MM_FUTISDOWN_PU",
      buttons = {buttonOk}
    }
    self.nav.Event(nil, "evt_show_popup", popupData)
    self.showLoginFailure = false
  end
end

function MainHub:updateliveTileFUT()
end

function MainHub:onLoggedIn()
  local isFUTReady = self.isFUTReady
  local loginStatus = self.services.userinfo.GetLoginStatus()
  if loginStatus == LoginStatus.LS_CONNECTED then
    self.services.futsquadmgmt.LoadActiveSquad()
    self.isFUTReady = true
  else
    self:showNoFutPopup()
    self.isFUTReady = false
  end
  if isFUTReady ~= self.isFUTReady then
    self:updateliveTileFUT()
  end
end

function MainHub:update(elapsedTime)
  if self.timer ~= nil then
    self.timer:update(elapsedTime)
  end
  self.models.FeatureTileModel:update(elapsedTime)
end

function MainHub:finalize()
  print("MainHub:finalize()")
  self.models.CABModel:finalize()
  self.models.FeatureTileModel:finalize()
  self.services.EventManagerService.UnregisterHandler(self.handlerId)
  self.im.Unsubscribe(bndLiveTileList)
  self.im.Unsubscribe(bndFUTTitle)
  self.im.Unsubscribe(bndEnableFUT)
  self.im.Unsubscribe(bndAccomplishmentsTitle)
  self.im.Unsubscribe(bndHelpTitle)
  self.im.Unsubscribe(bndAboutTitle)
  self.im.Unsubscribe(bndAdvertTitle)
  self.im.Unsubscribe(BND_DEBUG_VISIBILITY)
  self.im.Unsubscribe(bndLiveQuickMatchTileList)
end

return MainHub