-- SETTINGS BY MA'RUF ID YOUTUBE CHANNEL --

local TableUtil = (...)
local debugSettings = {}
local bndRenderResolution = "bnd_render_resolution"
local bndCrowdModeDefault = "bnd_crowd_mode_default"

---------------------------------------------------------------------------------------------------
local BND_DEBUG_SETTINGS_LIST_DATA = "bnd_debug_settings_list_data"
---------------------------------------------------------------------------------------------------

local actChangeRenderResolution = "act_change_render_resolution"
local actChangeCrowdModeDefault = "act_change_crowd_mode_default"

local RENDER_RESOLUTION_INDEX = 1
local CROWD_MODE_INDEX_DEFAULT = 2
local CrowdModeDefaultServiceIndex = 0

function debugSettings:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    settingsService = o.api("SettingsService"),
    gameStateService = o.api("GameStateService")
  }
  o:initValues()
  o.im.RegisterAction(actChangeRenderResolution, function(actionName, data)
    o:onRenderResolutionChanged(data)
  end)
  o.im.RegisterAction(actChangeCrowdModeDefault, function(actionName, data)
    o:onCrowdModeDefaultChanged(data)
  end)

  o.im.Subscribe(bndRenderResolution, function()
    o:publishRenderResolution()
  end)
  o.im.Subscribe(bndCrowdModeDefault, function()
    o:publishCrowdModeDefault()
  end)

  o.im.Subscribe(BND_DEBUG_SETTINGS_LIST_DATA, function()
    o:publishDebugSettingsListData()
  end)
  
  return o
end

function debugSettings:initValues()
  self.customizationOptions = self.services.settingsService.GetDebugSetting()
  self:initRenderResolutionData(self.customizationOptions[RENDER_RESOLUTION_INDEX].data)
  self:initCrowdModeDefaultData(self.customizationOptions[CROWD_MODE_INDEX_DEFAULT].data)
end
function debugSettings:initRenderResolutionData(renderResolutionData)
  self.renderResolutionData = renderResolutionData
  self.renderResolutionData.rowChangeAction = "act_change_render_resolution"
  self:setSelectedIndex(self.renderResolutionData)
end
function debugSettings:initCrowdModeDefaultData(crowdModeDefaultData)
  self.crowdModeDefaultData = crowdModeDefaultData
  self.crowdModeDefaultData.rowChangeAction = "act_change_crowd_mode_default"
  self:setSelectedIndex(self.crowdModeDefaultData)
end

function debugSettings:setSelectedIndex(optionData)
  local selectedIndex = self:GetValueIndex(optionData.data, optionData.currentValue)
  optionData.index = selectedIndex
end
function debugSettings:publishRenderResolution()
  self.im.Publish(bndRenderResolution, self.renderResolutionData)
end
function debugSettings:publishCrowdModeDefault()
  self.im.Publish(bndCrowdModeDefault, self.crowdModeDataDefault)
end

function debugSettings:onRenderResolutionChanged(newOption)
  local newValue = newOption.value
  if self.renderResolutionData.currentValue ~= newValue then
    self.renderResolutionData.currentValue = newValue
    self.services.settingsService.SaveRenderResolutionValue(newValue)
  end
end
function debugSettings:onCrowdModeDefaultChanged(newOption)
  local newValue = newOption.value
  if self.crowdModeDefaultData.currentValue ~= newValue then
    self.crowdModeDefaultData.currentValue = newValue
    self.services.settingsService.SaveCrowdModeValue(newValue, CrowdModeDefaultServiceIndex)
  end
end

function debugSettings:publishDebugSettingsListData()
  local dirtyIndices = {}
  local nRows = 2
  for i = 0, nRows do
    table.insert(dirtyIndices, i)
  end
  local dataList = {
    dirty = dirtyIndices,
    data = {
      {
        data = self.renderResolutionData
      },
      {
        data = self.crowdModeDefaultData
      }
    }
  }
  self.im.Publish(BND_DEBUG_SETTINGS_LIST_DATA, dataList)
end
function debugSettings:GetValueIndex(data, value)
  local i = 1
  while i <= #data and data[i].value ~= value do
    i = i + 1
  end
  return i - 1
end
function debugSettings:finalize()
  self.im.Unsubscribe(bndRenderResolution)
  self.im.Unsubscribe(bndCrowdModeDefault)

  self.im.Unsubscribe(BND_DEBUG_SETTINGS_LIST_DATA)
  
  self.im.UnregisterAction(actChangeRenderResolution)
  self.im.UnregisterAction(actChangeCrowdModeDefault)

end
return debugSettings